(* Content-type: application/vnd.wolfram.cdf.text *)

(*** Wolfram CDF File ***)
(* http://www.wolfram.com/cdf *)

(* CreatedBy='Mathematica 8.0' *)

(*************************************************************************)
(*                                                                       *)
(*  The Mathematica License under which this file was created prohibits  *)
(*  restricting third parties in receipt of this file from republishing  *)
(*  or redistributing it by any means, including but not limited to      *)
(*  rights management or terms of use, without the express consent of    *)
(*  Wolfram Research, Inc.                                               *)
(*                                                                       *)
(*************************************************************************)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       835,         17]
NotebookDataLength[     33236,        841]
NotebookOptionsPosition[     32758,        812]
NotebookOutlinePosition[     33093,        827]
CellTagsIndexPosition[     33050,        824]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
(* Relate the virial coefficients of the 1st and 2nd types.
Computable Document Format (e.g., Mathematica)
Kevin Davies 10/25/2011, revised 1/29/2012
See:
(1) [Dymond2002, pp. 1-2]
(2) [Salzman2004] *)\
\>", "Input",
 CellChangeTimes->{{3.536877949153512*^9, 3.536877982174435*^9}, {
  3.552264023094922*^9, 3.552264030061914*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"pfunc", ",", "nfunc", ",", "Z1", ",", "Z2", ",", "p", ",", "n"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.536861386137869*^9, 3.536861390845347*^9}, 
   3.536861541425406*^9, {3.536861572187843*^9, 3.536861602843355*^9}, {
   3.536861743154672*^9, 3.536861743631448*^9}, {3.536861963733618*^9, 
   3.536861985706029*^9}, 3.536863499446457*^9, {3.536869308865973*^9, 
   3.536869369305214*^9}, {3.536872097054204*^9, 3.53687212150903*^9}, {
   3.536872184956096*^9, 3.536872199444363*^9}, {3.536872306257747*^9, 
   3.536872355167425*^9}, {3.53687284216111*^9, 3.53687284308815*^9}, {
   3.536873967860899*^9, 3.536873973597121*^9}, {3.536874290503316*^9, 
   3.536874319532955*^9}, {3.536874554108508*^9, 3.536874557683839*^9}, {
   3.536874596195631*^9, 3.536874596293308*^9}, {3.536874681764151*^9, 
   3.5368747182971*^9}, {3.536875173050145*^9, 3.536875192610128*^9}, {
   3.536877934749229*^9, 3.536877964085092*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"The", " ", "order", " ", "of", " ", "n", " ", "or", " ", "p", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
      "in", " ", "the", " ", "case", " ", "of", " ", "a", " ", "and", " ", 
       "b"}], ",", " ", "respectively"}], ")"}], " ", "increases", " ", "by", 
    " ", "the", " ", "first", " ", 
    RowBox[{"index", ".", "  ", "The"}], " ", "order", " ", "of", " ", "T", 
    " ", "increases", " ", "by", " ", "the", " ", "second", " ", 
    RowBox[{"index", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"a", ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", "1", "}"}], "}"}], "\[IndentingNewLine]", "b"}], ":=", 
     RowBox[{"{", 
      RowBox[{"{", "1", "}"}], "}"}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"a", ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "B", "}"}], ",", 
        RowBox[{"{", "C", "}"}], ",", 
        RowBox[{"{", "D", "}"}]}], "}"}], "\[IndentingNewLine]", "b"}], ":=", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "Bstar", "}"}], ",", 
       RowBox[{"{", "Cstar", "}"}], ",", 
       RowBox[{"{", "Dstar", "}"}]}], "}"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"a", ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "a2", "}"}], ",", 
      RowBox[{"{", "a3", "}"}], ",", 
      RowBox[{"{", "a4", "}"}], ",", 
      RowBox[{"{", "a5", "}"}], ",", 
      RowBox[{"{", "a6", "}"}]}], "}"}]}], "\n", 
   RowBox[{"b", ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "b2", "}"}], ",", 
      RowBox[{"{", "b3", "}"}], ",", 
      RowBox[{"{", "b4", "}"}], ",", 
      RowBox[{"{", "b5", "}"}], ",", 
      RowBox[{"{", "b6", "}"}]}], "}"}], " "}]}]}]], "Input",
 CellChangeTimes->{{3.536877965148095*^9, 3.536877967375815*^9}, 
   3.556644972070579*^9, {3.569070141201535*^9, 3.569070164974996*^9}, {
   3.56907023069931*^9, 3.569070244805401*^9}, {3.569071878228937*^9, 
   3.569071884100028*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Below", ",", " ", 
   RowBox[{
   "pfunc", " ", "is", " ", "pressure", " ", "as", " ", "a", " ", "function", 
    " ", "of", " ", "temperature", " ", "and", " ", "volumetric", " ", 
    RowBox[{"density", ".", "  ", "nfunc"}], " ", "is", " ", "density", " ", 
    "as", " ", "a", " ", "function", " ", "of", " ", "temperature", " ", 
    "and", " ", 
    RowBox[{"pressure", ".", "  ", "p"}], " ", "and", " ", "n", " ", "are", 
    " ", "used", " ", "as", " ", "the", " ", "variables", " ", "for", " ", 
    "pressure", " ", "and", " ", "density", " ", 
    RowBox[{
     RowBox[{"(", "respectively", ")"}], "."}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.536861476151503*^9, 3.536861504026064*^9}, {
  3.536861874964934*^9, 3.536861892244985*^9}, {3.536869565037464*^9, 
  3.536869594156557*^9}, {3.536875211704933*^9, 3.536875230654936*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Explicit", " ", "in", " ", "pressure", " ", 
    RowBox[{"(", 
     RowBox[{"Type", " ", "1"}], ")"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"pfunc", "[", 
     RowBox[{"n_", ",", "T_"}], "]"}], ":=", 
    RowBox[{"R", "*", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}], 
           RowBox[{"T", "^", "j"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", 
            RowBox[{"Length", "[", 
             RowBox[{"a", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
        RowBox[{"n", "^", "i"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "a", "]"}]}], "}"}]}], "]"}]}]}], "\n", "\n", 
   
   RowBox[{"(*", " ", 
    RowBox[{"Explicit", " ", "in", " ", "density", " ", 
     RowBox[{"(", 
      RowBox[{"Type", " ", "2"}], ")"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"nfunc", "[", 
     RowBox[{"p_", ",", "T_"}], "]"}], ":=", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"R", "*", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"b", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "j"}], "]"}], "]"}], 
             RowBox[{"T", "^", "j"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "1", ",", 
              RowBox[{"Length", "[", 
               RowBox[{"b", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
          RowBox[{"p", "^", 
           RowBox[{"(", 
            RowBox[{"i", "-", "2"}], ")"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "b", "]"}]}], "}"}]}], "]"}]}], ")"}]}]}], 
   "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Compressibility", " ", "factors", " ", 
     RowBox[{"(", 
      RowBox[{"Z", " ", "=", " ", 
       RowBox[{"P", "/", 
        RowBox[{"(", 
         RowBox[{"n", "*", "T"}], ")"}]}]}], ")"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"Z1", "[", 
     RowBox[{"n_", ",", "T_"}], "]"}], ":=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"pfunc", "[", 
       RowBox[{"n", ",", "T"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"n", "*", "R", "*", "T"}], ")"}]}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"Z2", "[", 
     RowBox[{"p_", ",", "T_"}], "]"}], ":=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"p", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"nfunc", "[", 
         RowBox[{"p", ",", "T"}], "]"}], "*", "R", "*", "T"}], ")"}]}], 
     "]"}]}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Show", " ", "the", " ", "compressibility", " ", "factors", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"to", " ", "check"}], ")"}], "."}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"This", " ", "should", " ", "match", " ", 
     RowBox[{"Eqs", ".", " ", "1.2"}], " ", "and", " ", "1.3", " ", "from", 
     " ", "Dymond2002", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"p", ".", " ", "1"}], ")"}], "."}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Z1", "[", 
    RowBox[{"n", ",", "T"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Z2", "[", 
    RowBox[{"p", ",", "T"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.536861483817878*^9, 3.536861523980572*^9}, {
   3.536861584035944*^9, 3.53686158688935*^9}, {3.536861673068974*^9, 
   3.536861702085579*^9}, {3.536861990207809*^9, 3.536861991926901*^9}, {
   3.536869336604517*^9, 3.536869347787691*^9}, {3.536869423993357*^9, 
   3.536869451011023*^9}, 3.536872180176107*^9, {3.536873765296704*^9, 
   3.536873774098276*^9}, {3.536873808793202*^9, 3.536873822567342*^9}, {
   3.53687387321234*^9, 3.536873876211743*^9}, {3.536873990963408*^9, 
   3.536873992132636*^9}, {3.536874731102541*^9, 3.536874737047782*^9}}],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"a2", " ", "n"}], "+", 
  RowBox[{"a3", " ", 
   SuperscriptBox["n", "2"]}], "+", 
  RowBox[{"a4", " ", 
   SuperscriptBox["n", "3"]}], "+", 
  RowBox[{"a5", " ", 
   SuperscriptBox["n", "4"]}], "+", 
  RowBox[{"a6", " ", 
   SuperscriptBox["n", "5"]}]}]], "Output",
 CellChangeTimes->{
  3.536873993742463*^9, 3.536874323068618*^9, 3.536874561409014*^9, {
   3.569070182264973*^9, 3.569070208755319*^9}, 3.569070248479758*^9, 
   3.569071887202884*^9}],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"b2", " ", "p"}], "+", 
  RowBox[{"b3", " ", 
   SuperscriptBox["p", "2"]}], "+", 
  RowBox[{"b4", " ", 
   SuperscriptBox["p", "3"]}], "+", 
  RowBox[{"b5", " ", 
   SuperscriptBox["p", "4"]}], "+", 
  RowBox[{"b6", " ", 
   SuperscriptBox["p", "5"]}]}]], "Output",
 CellChangeTimes->{
  3.536873993742463*^9, 3.536874323068618*^9, 3.536874561409014*^9, {
   3.569070182264973*^9, 3.569070208755319*^9}, 3.569070248479758*^9, 
   3.56907188720872*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determine", " ", "Type", " ", "1", " ", "coefficients", " ", "in", " ", 
    "terms", " ", "of", " ", "Type", " ", "2", " ", 
    RowBox[{"coefficients", "."}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "The", " ", "terms", " ", "that", " ", "contain", " ", "density", " ", 
      RowBox[{"(", "n", ")"}], " ", "are", " ", "eliminated", " ", "by", " ", 
      "taking", " ", "the", " ", "limits", " ", "as", " ", "n"}], "->", 
     RowBox[{
      RowBox[{"Infinity", ".", "  ", 
       RowBox[{"I", "'"}]}], "m", " ", "not", " ", "sure", " ", "why", " ", 
      "that", " ", "is", " ", "necessary"}]}], ",", " ", 
    RowBox[{"but", " ", "it", " ", "matches", " ", 
     RowBox[{"Eqs", ".", " ", "1.4"}], " ", "through", " ", "1.6", " ", 
     "from", " ", "Dymond2002", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"p", ".", " ", "2"}], ")"}], "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"residual", "=", 
     RowBox[{
      RowBox[{"Z1", "[", 
       RowBox[{"n", ",", "T"}], "]"}], "-", 
      RowBox[{"Z2", "[", 
       RowBox[{
        RowBox[{"pfunc", "[", 
         RowBox[{"n", ",", "T"}], "]"}], ",", "T"}], "]"}]}]}], ";"}], "\n", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"residual", ",", "n", ",", "0"}], "]"}], "\n", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Limit", "[", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"residual", ",", "n", ",", "1"}], "]"}], ",", 
         RowBox[{"n", "->", "Infinity"}]}], "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{"a", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "\n", 
   RowBox[{"Simplify", "[", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{"residual", ",", "n", ",", "2"}], "]"}], ",", 
            RowBox[{"n", "->", "Infinity"}]}], "]"}], "\[Equal]", "0"}], ",", 
         
         RowBox[{"a", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "%"}], "]"}], "]"}], "\n", 
   RowBox[{"Simplify", "[", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{"residual", ",", "n", ",", "3"}], "]"}], ",", 
            RowBox[{"n", "->", "Infinity"}]}], "]"}], "\[Equal]", "0"}], ",", 
         
         RowBox[{"a", "[", 
          RowBox[{"[", 
           RowBox[{"4", ",", "1"}], "]"}], "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"%", ",", "%%"}], "}"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{"residual", ",", "n", ",", "4"}], "]"}], ",", 
            RowBox[{"n", "->", "Infinity"}]}], "]"}], "\[Equal]", "0"}], ",", 
         
         RowBox[{"a", "[", 
          RowBox[{"[", 
           RowBox[{"5", ",", "1"}], "]"}], "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"%", ",", "%%", ",", "%%%"}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{"residual", ",", "n", ",", "5"}], "]"}], ",", 
            RowBox[{"n", "->", "Infinity"}]}], "]"}], "\[Equal]", "0"}], ",", 
         
         RowBox[{"a", "[", 
          RowBox[{"[", 
           RowBox[{"6", ",", "1"}], "]"}], "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"%", ",", "%%", ",", "%%%", ",", "%%%%"}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.536861677613472*^9, {3.536869459871912*^9, 3.536869466800289*^9}, {
   3.536869547992407*^9, 3.536869549753504*^9}, {3.536872627804792*^9, 
   3.536872661857067*^9}, 3.536872710627058*^9, {3.536872756994637*^9, 
   3.536872820496295*^9}, {3.536872861231221*^9, 3.536872863294697*^9}, {
   3.536873561694455*^9, 3.536873642238391*^9}, {3.536873677160784*^9, 
   3.536873705333782*^9}, {3.536874343005723*^9, 3.536874443666274*^9}, {
   3.5368744930361*^9, 3.536874524102963*^9}, {3.536874571780069*^9, 
   3.536874575578744*^9}, {3.536874750114075*^9, 3.536874770611479*^9}, {
   3.569070196283014*^9, 3.569070198483804*^9}, {3.569070459431983*^9, 
   3.569070488887496*^9}, {3.569071865996882*^9, 3.569071869657944*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.536861399638025*^9, 3.536861552230417*^9, {3.536861729827996*^9, 
   3.536861745750878*^9}, 3.53686201056931*^9, 3.536869290210338*^9, 
   3.536869390613077*^9, {3.536869468351991*^9, 3.53686951493968*^9}, 
   3.536869550404931*^9, 3.536869608062078*^9, {3.536872208847561*^9, 
   3.53687222687775*^9}, 3.536872364573115*^9, {3.536872633989418*^9, 
   3.536872663139172*^9}, {3.536872769678248*^9, 3.536872821264489*^9}, {
   3.536872856007588*^9, 3.536872863835801*^9}, {3.536873564200219*^9, 
   3.536873707456969*^9}, 3.536874009347318*^9, 3.536874328676892*^9, {
   3.536874380418215*^9, 3.536874444989573*^9}, 3.53687449509158*^9, 
   3.536874525848466*^9, {3.536874563577219*^9, 3.536874587233292*^9}, {
   3.56907018289462*^9, 3.569070209031717*^9}, 3.569070248902406*^9, {
   3.569070468430689*^9, 3.569070483107877*^9}, 3.56907188919586*^9}],

Cell[BoxData[
 RowBox[{"a2", "\[Rule]", 
  RowBox[{"b2", " ", "R", " ", "T"}]}]], "Output",
 CellChangeTimes->{
  3.536861399638025*^9, 3.536861552230417*^9, {3.536861729827996*^9, 
   3.536861745750878*^9}, 3.53686201056931*^9, 3.536869290210338*^9, 
   3.536869390613077*^9, {3.536869468351991*^9, 3.53686951493968*^9}, 
   3.536869550404931*^9, 3.536869608062078*^9, {3.536872208847561*^9, 
   3.53687222687775*^9}, 3.536872364573115*^9, {3.536872633989418*^9, 
   3.536872663139172*^9}, {3.536872769678248*^9, 3.536872821264489*^9}, {
   3.536872856007588*^9, 3.536872863835801*^9}, {3.536873564200219*^9, 
   3.536873707456969*^9}, 3.536874009347318*^9, 3.536874328676892*^9, {
   3.536874380418215*^9, 3.536874444989573*^9}, 3.53687449509158*^9, 
   3.536874525848466*^9, {3.536874563577219*^9, 3.536874587233292*^9}, {
   3.56907018289462*^9, 3.569070209031717*^9}, 3.569070248902406*^9, {
   3.569070468430689*^9, 3.569070483107877*^9}, 3.569071889264291*^9}],

Cell[BoxData[
 RowBox[{"a3", "\[Rule]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["b2", "2"], "+", "b3"}], ")"}], " ", 
   SuperscriptBox["R", "2"], " ", 
   SuperscriptBox["T", "2"]}]}]], "Output",
 CellChangeTimes->{
  3.536861399638025*^9, 3.536861552230417*^9, {3.536861729827996*^9, 
   3.536861745750878*^9}, 3.53686201056931*^9, 3.536869290210338*^9, 
   3.536869390613077*^9, {3.536869468351991*^9, 3.53686951493968*^9}, 
   3.536869550404931*^9, 3.536869608062078*^9, {3.536872208847561*^9, 
   3.53687222687775*^9}, 3.536872364573115*^9, {3.536872633989418*^9, 
   3.536872663139172*^9}, {3.536872769678248*^9, 3.536872821264489*^9}, {
   3.536872856007588*^9, 3.536872863835801*^9}, {3.536873564200219*^9, 
   3.536873707456969*^9}, 3.536874009347318*^9, 3.536874328676892*^9, {
   3.536874380418215*^9, 3.536874444989573*^9}, 3.53687449509158*^9, 
   3.536874525848466*^9, {3.536874563577219*^9, 3.536874587233292*^9}, {
   3.56907018289462*^9, 3.569070209031717*^9}, 3.569070248902406*^9, {
   3.569070468430689*^9, 3.569070483107877*^9}, 3.569071889376095*^9}],

Cell[BoxData[
 RowBox[{"a4", "\[Rule]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["b2", "3"], "+", 
     RowBox[{"3", " ", "b2", " ", "b3"}], "+", "b4"}], ")"}], " ", 
   SuperscriptBox["R", "3"], " ", 
   SuperscriptBox["T", "3"]}]}]], "Output",
 CellChangeTimes->{
  3.536861399638025*^9, 3.536861552230417*^9, {3.536861729827996*^9, 
   3.536861745750878*^9}, 3.53686201056931*^9, 3.536869290210338*^9, 
   3.536869390613077*^9, {3.536869468351991*^9, 3.53686951493968*^9}, 
   3.536869550404931*^9, 3.536869608062078*^9, {3.536872208847561*^9, 
   3.53687222687775*^9}, 3.536872364573115*^9, {3.536872633989418*^9, 
   3.536872663139172*^9}, {3.536872769678248*^9, 3.536872821264489*^9}, {
   3.536872856007588*^9, 3.536872863835801*^9}, {3.536873564200219*^9, 
   3.536873707456969*^9}, 3.536874009347318*^9, 3.536874328676892*^9, {
   3.536874380418215*^9, 3.536874444989573*^9}, 3.53687449509158*^9, 
   3.536874525848466*^9, {3.536874563577219*^9, 3.536874587233292*^9}, {
   3.56907018289462*^9, 3.569070209031717*^9}, 3.569070248902406*^9, {
   3.569070468430689*^9, 3.569070483107877*^9}, 3.569071889513263*^9}],

Cell[BoxData[
 RowBox[{"a5", "\[Rule]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["b2", "4"], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["b2", "2"], " ", "b3"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["b3", "2"]}], "+", 
     RowBox[{"4", " ", "b2", " ", "b4"}], "+", "b5"}], ")"}], " ", 
   SuperscriptBox["R", "4"], " ", 
   SuperscriptBox["T", "4"]}]}]], "Output",
 CellChangeTimes->{
  3.536861399638025*^9, 3.536861552230417*^9, {3.536861729827996*^9, 
   3.536861745750878*^9}, 3.53686201056931*^9, 3.536869290210338*^9, 
   3.536869390613077*^9, {3.536869468351991*^9, 3.53686951493968*^9}, 
   3.536869550404931*^9, 3.536869608062078*^9, {3.536872208847561*^9, 
   3.53687222687775*^9}, 3.536872364573115*^9, {3.536872633989418*^9, 
   3.536872663139172*^9}, {3.536872769678248*^9, 3.536872821264489*^9}, {
   3.536872856007588*^9, 3.536872863835801*^9}, {3.536873564200219*^9, 
   3.536873707456969*^9}, 3.536874009347318*^9, 3.536874328676892*^9, {
   3.536874380418215*^9, 3.536874444989573*^9}, 3.53687449509158*^9, 
   3.536874525848466*^9, {3.536874563577219*^9, 3.536874587233292*^9}, {
   3.56907018289462*^9, 3.569070209031717*^9}, 3.569070248902406*^9, {
   3.569070468430689*^9, 3.569070483107877*^9}, 3.569071889646778*^9}],

Cell[BoxData[
 RowBox[{"a6", "\[Rule]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["b2", "5"], "+", 
     RowBox[{"10", " ", 
      SuperscriptBox["b2", "3"], " ", "b3"}], "+", 
     RowBox[{"10", " ", 
      SuperscriptBox["b2", "2"], " ", "b4"}], "+", 
     RowBox[{"5", " ", "b3", " ", "b4"}], "+", 
     RowBox[{"5", " ", "b2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b3", "2"]}], "+", "b5"}], ")"}]}], "+", "b6"}], 
    ")"}], " ", 
   SuperscriptBox["R", "5"], " ", 
   SuperscriptBox["T", "5"]}]}]], "Output",
 CellChangeTimes->{
  3.536861399638025*^9, 3.536861552230417*^9, {3.536861729827996*^9, 
   3.536861745750878*^9}, 3.53686201056931*^9, 3.536869290210338*^9, 
   3.536869390613077*^9, {3.536869468351991*^9, 3.53686951493968*^9}, 
   3.536869550404931*^9, 3.536869608062078*^9, {3.536872208847561*^9, 
   3.53687222687775*^9}, 3.536872364573115*^9, {3.536872633989418*^9, 
   3.536872663139172*^9}, {3.536872769678248*^9, 3.536872821264489*^9}, {
   3.536872856007588*^9, 3.536872863835801*^9}, {3.536873564200219*^9, 
   3.536873707456969*^9}, 3.536874009347318*^9, 3.536874328676892*^9, {
   3.536874380418215*^9, 3.536874444989573*^9}, 3.53687449509158*^9, 
   3.536874525848466*^9, {3.536874563577219*^9, 3.536874587233292*^9}, {
   3.56907018289462*^9, 3.569070209031717*^9}, 3.569070248902406*^9, {
   3.569070468430689*^9, 3.569070483107877*^9}, 3.569071889866902*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determine", " ", "Type", " ", "2", " ", "coefficients", " ", "in", " ", 
    "terms", " ", "of", " ", "Type", " ", "1", " ", 
    RowBox[{"coefficients", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"residual", ",", "n", ",", "0"}], "]"}], "\n", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Limit", "[", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"residual", ",", "n", ",", "1"}], "]"}], ",", 
         RowBox[{"n", "->", "Infinity"}]}], "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{"b", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "\n", 
   RowBox[{"Simplify", "[", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{"residual", ",", "n", ",", "2"}], "]"}], ",", 
            RowBox[{"n", "->", "Infinity"}]}], "]"}], "\[Equal]", "0"}], ",", 
         
         RowBox[{"b", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "%"}], "]"}], "]"}], "\n", 
   RowBox[{"Simplify", "[", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{"residual", ",", "n", ",", "3"}], "]"}], ",", 
            RowBox[{"n", "->", "Infinity"}]}], "]"}], "\[Equal]", "0"}], ",", 
         
         RowBox[{"b", "[", 
          RowBox[{"[", 
           RowBox[{"4", ",", "1"}], "]"}], "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"%", ",", "%%"}], "}"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{"residual", ",", "n", ",", "4"}], "]"}], ",", 
            RowBox[{"n", "->", "Infinity"}]}], "]"}], "\[Equal]", "0"}], ",", 
         
         RowBox[{"b", "[", 
          RowBox[{"[", 
           RowBox[{"5", ",", "1"}], "]"}], "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"%", ",", "%%", ",", "%%%"}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{"residual", ",", "n", ",", "5"}], "]"}], ",", 
            RowBox[{"n", "->", "Infinity"}]}], "]"}], "\[Equal]", "0"}], ",", 
         
         RowBox[{"b", "[", 
          RowBox[{"[", 
           RowBox[{"6", ",", "1"}], "]"}], "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"%", ",", "%%", ",", "%%%", ",", "%%%%"}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.536861532734617*^9, 3.536861699392436*^9, {3.536862000695376*^9, 
   3.536862004962953*^9}, {3.536869396506808*^9, 3.536869403247807*^9}, {
   3.536872273329907*^9, 3.536872280201984*^9}, {3.536872386136029*^9, 
   3.536872390758355*^9}, 3.536872514393804*^9, {3.536874088147367*^9, 
   3.536874145103765*^9}, {3.536874224426969*^9, 3.536874269091418*^9}, {
   3.536874468679441*^9, 3.536874479142826*^9}, {3.536874511631476*^9, 
   3.536874519737081*^9}, {3.536874578974158*^9, 3.536874584123234*^9}, {
   3.536874651780504*^9, 3.536874652035867*^9}, {3.56907020413886*^9, 
   3.569070205815273*^9}, {3.569071870787247*^9, 3.56907187321621*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.536861399747307*^9, 3.536861552996748*^9, {3.536861729897232*^9, 
   3.536861745857892*^9}, 3.536862010920993*^9, 3.536869290267159*^9, {
   3.536869393642424*^9, 3.536869405098942*^9}, 3.536869518700134*^9, 
   3.536869553848608*^9, 3.53687225642241*^9, {3.536872367042597*^9, 
   3.53687239245828*^9}, {3.536874123315475*^9, 3.536874145776681*^9}, 
   3.536874240871493*^9, 3.536874281333175*^9, {3.53687450775379*^9, 
   3.536874528993513*^9}, 3.536874584990543*^9, 3.536874653936143*^9, {
   3.569070183643337*^9, 3.569070209940345*^9}, 3.569070249671916*^9, 
   3.569071890815761*^9}],

Cell[BoxData[
 RowBox[{"b2", "\[Rule]", 
  FractionBox["a2", 
   RowBox[{"R", " ", "T"}]]}]], "Output",
 CellChangeTimes->{
  3.536861399747307*^9, 3.536861552996748*^9, {3.536861729897232*^9, 
   3.536861745857892*^9}, 3.536862010920993*^9, 3.536869290267159*^9, {
   3.536869393642424*^9, 3.536869405098942*^9}, 3.536869518700134*^9, 
   3.536869553848608*^9, 3.53687225642241*^9, {3.536872367042597*^9, 
   3.53687239245828*^9}, {3.536874123315475*^9, 3.536874145776681*^9}, 
   3.536874240871493*^9, 3.536874281333175*^9, {3.53687450775379*^9, 
   3.536874528993513*^9}, 3.536874584990543*^9, 3.536874653936143*^9, {
   3.569070183643337*^9, 3.569070209940345*^9}, 3.569070249671916*^9, 
   3.569071890924429*^9}],

Cell[BoxData[
 RowBox[{"b3", "\[Rule]", 
  FractionBox[
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a2", "2"]}], "+", "a3"}], 
   RowBox[{
    SuperscriptBox["R", "2"], " ", 
    SuperscriptBox["T", "2"]}]]}]], "Output",
 CellChangeTimes->{
  3.536861399747307*^9, 3.536861552996748*^9, {3.536861729897232*^9, 
   3.536861745857892*^9}, 3.536862010920993*^9, 3.536869290267159*^9, {
   3.536869393642424*^9, 3.536869405098942*^9}, 3.536869518700134*^9, 
   3.536869553848608*^9, 3.53687225642241*^9, {3.536872367042597*^9, 
   3.53687239245828*^9}, {3.536874123315475*^9, 3.536874145776681*^9}, 
   3.536874240871493*^9, 3.536874281333175*^9, {3.53687450775379*^9, 
   3.536874528993513*^9}, 3.536874584990543*^9, 3.536874653936143*^9, {
   3.569070183643337*^9, 3.569070209940345*^9}, 3.569070249671916*^9, 
   3.569071890926484*^9}],

Cell[BoxData[
 RowBox[{"b4", "\[Rule]", 
  FractionBox[
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["a2", "3"]}], "-", 
    RowBox[{"3", " ", "a2", " ", "a3"}], "+", "a4"}], 
   RowBox[{
    SuperscriptBox["R", "3"], " ", 
    SuperscriptBox["T", "3"]}]]}]], "Output",
 CellChangeTimes->{
  3.536861399747307*^9, 3.536861552996748*^9, {3.536861729897232*^9, 
   3.536861745857892*^9}, 3.536862010920993*^9, 3.536869290267159*^9, {
   3.536869393642424*^9, 3.536869405098942*^9}, 3.536869518700134*^9, 
   3.536869553848608*^9, 3.53687225642241*^9, {3.536872367042597*^9, 
   3.53687239245828*^9}, {3.536874123315475*^9, 3.536874145776681*^9}, 
   3.536874240871493*^9, 3.536874281333175*^9, {3.53687450775379*^9, 
   3.536874528993513*^9}, 3.536874584990543*^9, 3.536874653936143*^9, {
   3.569070183643337*^9, 3.569070209940345*^9}, 3.569070249671916*^9, 
   3.569071891040444*^9}],

Cell[BoxData[
 RowBox[{"b5", "\[Rule]", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "5"}], " ", 
     SuperscriptBox["a2", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a2", "2"], " ", "a3"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a3", "2"]}], "-", 
    RowBox[{"4", " ", "a2", " ", "a4"}], "+", "a5"}], 
   RowBox[{
    SuperscriptBox["R", "4"], " ", 
    SuperscriptBox["T", "4"]}]]}]], "Output",
 CellChangeTimes->{
  3.536861399747307*^9, 3.536861552996748*^9, {3.536861729897232*^9, 
   3.536861745857892*^9}, 3.536862010920993*^9, 3.536869290267159*^9, {
   3.536869393642424*^9, 3.536869405098942*^9}, 3.536869518700134*^9, 
   3.536869553848608*^9, 3.53687225642241*^9, {3.536872367042597*^9, 
   3.53687239245828*^9}, {3.536874123315475*^9, 3.536874145776681*^9}, 
   3.536874240871493*^9, 3.536874281333175*^9, {3.53687450775379*^9, 
   3.536874528993513*^9}, 3.536874584990543*^9, 3.536874653936143*^9, {
   3.569070183643337*^9, 3.569070209940345*^9}, 3.569070249671916*^9, 
   3.569071891042443*^9}],

Cell[BoxData[
 RowBox[{"b6", "\[Rule]", 
  FractionBox[
   RowBox[{
    RowBox[{"14", " ", 
     SuperscriptBox["a2", "5"]}], "-", 
    RowBox[{"35", " ", 
     SuperscriptBox["a2", "3"], " ", "a3"}], "+", 
    RowBox[{"15", " ", "a2", " ", 
     SuperscriptBox["a3", "2"]}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["a2", "2"], " ", "a4"}], "-", 
    RowBox[{"5", " ", "a3", " ", "a4"}], "-", 
    RowBox[{"5", " ", "a2", " ", "a5"}], "+", "a6"}], 
   RowBox[{
    SuperscriptBox["R", "5"], " ", 
    SuperscriptBox["T", "5"]}]]}]], "Output",
 CellChangeTimes->{
  3.536861399747307*^9, 3.536861552996748*^9, {3.536861729897232*^9, 
   3.536861745857892*^9}, 3.536862010920993*^9, 3.536869290267159*^9, {
   3.536869393642424*^9, 3.536869405098942*^9}, 3.536869518700134*^9, 
   3.536869553848608*^9, 3.53687225642241*^9, {3.536872367042597*^9, 
   3.53687239245828*^9}, {3.536874123315475*^9, 3.536874145776681*^9}, 
   3.536874240871493*^9, 3.536874281333175*^9, {3.53687450775379*^9, 
   3.536874528993513*^9}, 3.536874584990543*^9, 3.536874653936143*^9, {
   3.569070183643337*^9, 3.569070209940345*^9}, 3.569070249671916*^9, 
   3.569071891048826*^9}]
}, Open  ]]
},
WindowSize->{1674, 967},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Linux x86 (32-bit) (October 10, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[1235, 30, 341, 9, 110, "Input"],
Cell[1579, 41, 973, 15, 30, "Input"],
Cell[2555, 58, 2225, 61, 145, "Input"],
Cell[4783, 121, 897, 16, 50, "Input"],
Cell[CellGroupData[{
Cell[5705, 141, 4182, 114, 278, "Input"],
Cell[9890, 257, 497, 14, 30, "Output"],
Cell[10390, 273, 496, 14, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10923, 292, 5341, 140, 202, "Input"],
Cell[16267, 434, 903, 13, 30, "Output"],
Cell[17173, 449, 967, 15, 30, "Output"],
Cell[18143, 466, 1094, 20, 33, "Output"],
Cell[19240, 488, 1142, 21, 33, "Output"],
Cell[20385, 511, 1283, 25, 33, "Output"],
Cell[21671, 538, 1465, 31, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23173, 574, 4240, 113, 145, "Input"],
Cell[27416, 689, 642, 10, 30, "Output"],
Cell[28061, 701, 717, 13, 47, "Output"],
Cell[28781, 716, 841, 18, 50, "Output"],
Cell[29625, 736, 893, 19, 50, "Output"],
Cell[30521, 757, 1052, 24, 50, "Output"],
Cell[31576, 783, 1166, 26, 50, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

(* NotebookSignature Qwp2dofwqhjNWB1PXPAk3Bk# *)
